<?php
/*
* Inserta un menú en la adminstración de wordpress, para la modificacion de parametros de la factura.
*/
defined( 'ABSPATH' ) || exit;

/////// ARTURO: MENU PARAMETROS FACTURA
  ///////REGISTRAR UN ELEMENTO DE MENU
  function dbi_add_settings_page() {
      add_options_page( 'Parametros Factura', 'Parametros Factura', 'manage_options', 'dbi-ownparameters-plugin', 'invoices_render_page' );
  }
  add_action( 'admin_menu', 'dbi_add_settings_page' );

  //////EL FORMULARIO

  function invoices_render_page() {
      ?>
      <h2>Configuraciones Personalizadas para la Tienda</h2>
      <form action="options.php" method="post">
          <?php 
          settings_fields( '_invoices_options' ); //Parametro: nombre para el grupo de configuracion ***
          do_settings_sections( 'invoices_fields' ); //Parametro se usara para registrar campos?>
          <input name="submit" class="button button-primary" type="submit" value="<?php esc_attr_e( 'Save' ); ?>" />
		  <hr>
	<p>ADICIONALMENTE ESTAN DISPONIBLES LOS SIGUIENTES SHORTCODES:</p>
	<p>-   <b>[correo]</b> (El correo asignado a esta tienda en etiquetas &lt;a&gt;)</p>
	<p>-   <b>[urltienda]</b> (La URL de esta tienda en etiquetas &lt;a&gt;)</p>
      </form>
      <?php
  }

  //////REGISTRANDO LOS CAMPOS O VARIABLES EN LA BASE DE DATOS [PASO 1]

  function dbi_register_settings() {
      register_setting( '_invoices_options', '_invoices_options', '_invoices_options_validate' );
      add_settings_section( 'store_settings', 'Factura 2', 'invoices_section_text', 'invoices_fields' );

      add_settings_field( 'invoices_setting_ustidnr', 'USt-IdNr', 'invoices_setting_ustidnr', 'invoices_fields', 'store_settings' );
      add_settings_field( 'invoices_setting_correo_factura', 'Corréo Factura', 'invoices_setting_correo_factura', 'invoices_fields', 'store_settings' );
      add_settings_field( 'invoices_setting_direccion_factura', 'Dirección Factura', 'invoices_setting_direccion_factura', 'invoices_fields', 'store_settings' );

  	  add_settings_field( 'invoices_setting_direccion2_factura', 'Dirección Factura 2', 'invoices_setting_direccion2_factura', 'invoices_fields', 'store_settings' );
      add_settings_field( 'invoices_setting_mspartner', 'Microsoft Partner Number', 'invoices_setting_mspartner', 'invoices_fields', 'store_settings' );
      add_settings_field( 'invoices_setting_telefono', 'Teléfono', 'invoices_setting_telefono', 'invoices_fields', 'store_settings' );

      add_settings_field( 'invoices_setting_vertrag', 'Raiz Vertrag', 'invoices_setting_vertrag', 'invoices_fields', 'store_settings' );
      add_settings_field( 'invoices_setting_lizenzgeber', 'Raiz Lizenzgeber', 'invoices_setting_lizenzgeber', 'invoices_fields', 'store_settings' );
      add_settings_field( 'invoices_setting_mostrar2factura', 'Mostrar la hoja 2 factura (S/N)', 'invoices_setting_mostrar2factura', 'invoices_fields', 'store_settings' );
      add_settings_field( 'invoices_setting_genverliz', 'Generar Vertrag y Lizenzgeber? (S/N)', 'invoices_setting_genverliz', 'invoices_fields', 'store_settings' );
      //add_settings_field( 'invoices_setting_padrehijo', 'Paypal Padre o Hijo? (P/H)','invoices_setting_padrehijo', 'invoices_fields', 'store_settings' );
	
      add_settings_field( 'invoices_setting_mailtraintracking', 'Activar Mailtrain Tracking?','invoices_setting_mailtraintracking', 'invoices_fields', 'store_settings' );

      add_settings_field( 'invoices_setting_combos', 'Combos (COMBO#SKU|ID*ID)', 'invoices_setting_combos', 'invoices_fields', 'store_settings' );

      //add_settings_section( 'metpago_settings', 'Imagen Metodos de pagoS', 'invoices_section_text1', 'invoices_fields' );
      //add_settings_field( 'invoices_setting_imgmetpago', 'Ruta de la imagen', 'invoices_setting_imgmetpago', 'invoices_fields', 'metpago_settings' );
	  
  }
  add_action( 'admin_init', 'dbi_register_settings' );

  /////VALIDACION

  function _invoices_options_validate( $input ) {
      $newinput['ustidnr'] = trim( $input['ustidnr'] );
      if ( ! preg_match( '/^[a-z0-9]{32}$/i', $newinput['ustidnr'] ) ) {
          $newinput['ustidnr'] = '';
      }
      if($input['padrehijo']=="P"){ 
		  $uno = $GLOBALS['wpdb']->get_var("SELECT 1 AS res FROM wp_options WHERE option_name = '_pp_checkout_padre'");//_pp_checkout_padre
		  if ($uno==1){
			$GLOBALS['wpdb']->update('wp_options',array('option_value' => get_current_blog_id()),array('option_name' => '_pp_checkout_padre'));
		  }else{
			$GLOBALS['wpdb']->insert('wp_options',array('option_id' => 0, 'option_name' => '_pp_checkout_padre', 'option_value' => get_current_blog_id(), 'autoload' => 'no'));
		  }
		$GLOBALS['wpdb']->update('wp_options',array('option_value' => 0),array('option_name' => '_pp_payments_padre'));
	  } 
      if($input['padrehijo']=="Q"){
		  $uno = $GLOBALS['wpdb']->get_var("SELECT 1 FROM wp_options WHERE option_name = '_pp_payments_padre'");//_pp_payments_padre
		  if ($uno==1){
			$GLOBALS['wpdb']->update('wp_options',array('option_value' => get_current_blog_id()),array('option_name' => '_pp_payments_padre'));
		  }else{
			$GLOBALS['wpdb']->insert('wp_options',array('option_id' => 0, 'option_name' => '_pp_payments_padre', 'option_value' => get_current_blog_id(), 'autoload' => 'no'));
		  }
		$GLOBALS['wpdb']->update('wp_options',array('option_value' => 0),array('option_name' => '_pp_checkout_padre'));
	  } 

      if($input['pp_servidor']=="S"){
		$server_id=get_current_blog_id(); 
		$server_url=get_site_url();
		switch_to_blog(1);
			$old_server_id=get_option('_pp_server_id');
			update_option('_pp_server_url',$server_url,false);
			update_option('_pp_server_id',$server_id,false);
		restore_current_blog();
	  } 
      //return $newinput; 
      return $input;
  }

//////////LOS CAMPOS DEL FORMULARIO, LOS QUE SE VEN [PASO 2]

function invoices_section_text() {
	echo '<p>Configuraciones Personalizadas Para la 2da hoja de la factura</p>';
}

function invoices_setting_ustidnr() {
  $options = get_option( '_invoices_options' );
  echo "<input id='invoices_setting_ustidnr' name='_invoices_options[ustidnr]' type='text' value='".esc_attr( $options['ustidnr'] )."' /> Shortcode:[ustidnr]";
}

function invoices_setting_correo_factura() {
  $options = get_option( '_invoices_options' );
  echo "<input id='invoices_setting_correo_factura' name='_invoices_options[correo_factura]' type='text' value='".esc_attr($options['correo_factura'] )."' /> Shortcode:[correo]";
}

function invoices_setting_direccion_factura() {
  $options = get_option( '_invoices_options' );
  echo "<textarea id='invoices_setting_direccion_factura' name='_invoices_options[direccion_factura]' cols=80>".esc_attr( $options['direccion_factura'] )."</textarea> Shortcode:[direccion]";
}

function invoices_setting_direccion2_factura() {
  $options = get_option( '_invoices_options' );
  echo "<textarea id='invoices_setting_direccion2_factura' name='_invoices_options[direccion2_factura]' type='text' cols=80>".esc_attr( $options['direccion2_factura'] )."</textarea> Shortcode:[direccion2]";
}

function invoices_setting_mspartner() {
  $options = get_option( '_invoices_options' );
  echo "<input id='invoices_setting_mspartner' name='_invoices_options[mspartner]' type='text' value='".esc_attr( $options['mspartner'] )."' /> Shortcode:[mspartner]";
}

function invoices_setting_telefono() {
  $options = get_option( '_invoices_options' );
  echo "<input id='invoices_setting_telefono' name='_invoices_options[telefono]' type='text' value='".esc_attr( $options['telefono'] )."' /> Shortcode:[telefono]";
}

function invoices_setting_vertrag() {
  $options = get_option( '_invoices_options' );
  echo "<input id='invoices_setting_vertrag' name='_invoices_options[vertrag]' type='text' value='".esc_attr( $options['vertrag'] )."' /> Shortcode:[vertrag]";
}

function invoices_setting_lizenzgeber() {
  $options = get_option( '_invoices_options' );
  echo "<input id='invoices_setting_lizenzgeber' name='_invoices_options[lizenzgeber]' type='text' value='".esc_attr( $options['lizenzgeber'] )."' /> Shortcode:[lizenzgeber]";
}

function invoices_setting_mostrar2factura() {
  $options = get_option( '_invoices_options' );
  //echo "<input id='invoices_setting_mostrar2factura' name='_invoices_options[mostrar2factura]' type='text' value='".esc_attr( $options['mostrar2factura'] )."' /> ";
  $checked = $options['mostrar2factura']=="S"?"checked":"";
  echo '<input type="radio" id="invoices_setting_mostrar2factura" name="_invoices_options[mostrar2factura]" value="S" '.$checked.'><label for="_invoices_options[mostrar2factura]">Si</label>'; 
  $checked = $options['mostrar2factura']=="N"?"checked":"";
  echo '<input type="radio" id="invoices_setting_mostrar2factura" name="_invoices_options[mostrar2factura]" value="N" '.$checked.'><label for="_invoices_options[mostrar2factura]">No</label>'; 
}

function invoices_setting_genverliz() { // S=genera Vertrag y Lizenzgeber a partir de options; N=toma estos valores de los atributos.
  $options = get_option( '_invoices_options' );
  //echo "<input id='invoices_setting_genverliz' name='_invoices_options[genverliz]' type='text' value='".esc_attr( $options['genverliz'] )."' /> ";
  $checked = $options['genverliz']=="S"?"checked":"";
  echo '<input type="radio" id="invoices_setting_genverliz" name="_invoices_options[genverliz]" value="S" '.$checked.'><label for="invoices_setting_genverliz">Si</label>'; 
  $checked = $options['genverliz']=="N"?"checked":"";
  echo '<input type="radio" id="invoices_setting_genverliz" name="_invoices_options[genverliz]" value="N" '.$checked.'><label for="invoices_setting_genverliz">No</label>'; 
}

function invoices_setting_padrehijo() { // P=incluye paypal-padre.php H=incluye paypa-hijo.php). YA NO SE USA
  $options = get_option( '_invoices_options' );
  echo "<span style='border:solid 1px gray; border-radius:5px;padding:10px;width:300px;'>";
  $checked = $options['padrehijo']=="P"?"checked":"";
  echo 'Paypal Checkout:&nbsp;&nbsp;<input type="radio" id="invoices_setting_padrehijo" name="_invoices_options[padrehijo]" value="P" '.$checked.'><label for="invoices_setting_padrehijo">Padre</label>&nbsp;&nbsp;&nbsp;'; 
  $checked = $options['padrehijo']=="H"?"checked":"";
  echo '<input type="radio" id="invoices_setting_padrehijo" name="_invoices_options[padrehijo]" value="H" '.$checked.'><label for="invoices_setting_padrehijo">Hijo</label>'; 
  $checked = $options['padrehijo']=="Q"?"checked":"";
  echo "</span>&nbsp;&nbsp;";
  echo "<span style='border:solid 1px gray; border-radius:5px;padding:10px;width:300px;'>";
  echo 'Paypal Payments:&nbsp;&nbsp;&nbsp;<input type="radio" id="invoices_setting_padrehijo" name="_invoices_options[padrehijo]" value="Q" '.$checked.'><label for="invoices_setting_padrehijo">Padre</label>&nbsp;&nbsp;&nbsp;'; 
  $checked = $options['padrehijo']=="I"?"checked":"";
  echo '<input type="radio" id="invoices_setting_padrehijo" name="_invoices_options[padrehijo]" value="I" '.$checked.'><label for="invoices_setting_padrehijo">Hijo</label>'; 
  echo "</span>";
}

function invoices_setting_mailtraintracking() { // S=incluye columna mailtran en orders N=no lo hace.
  $options = get_option( '_invoices_options' );
  $checked = $options['mailtraintracking']=="S"?"checked":"";
  echo '<input type="radio" id="invoices_setting_mailtraintracking" name="_invoices_options[mailtraintracking]" value="S" '.$checked.'><label for="invoices_setting_mailtraintracking">Si</label>'; 
  $checked = $options['mailtraintracking']=="N"?"checked":"";
  echo '<input type="radio" id="invoices_setting_mailtraintracking" name="_invoices_options[mailtraintracking]" value="N" '.$checked.'><label for="invoices_setting_mailtraintracking">No</label>'; 
}

function invoices_setting_combos() { // Combos (COMBO#SKU|ID*ID)
  $options = get_option( '_invoices_options' );
  echo "<input id='invoices_setting_combos' name='_invoices_options[combos]' type='text' value='".esc_attr( $options['combos'] )."' /> ";
}

  //CARGA EL LA INFORMACIÓN COMO SHORTCODE
  add_shortcode( 'ustidnr', 'agregaustidnr' );
  add_shortcode( 'correo', 'agregacorreo' );
  add_shortcode( 'direccion', 'agregadireccion' );
  add_shortcode( 'direccion2', 'agregadireccion2' );
  add_shortcode( 'mspartner', 'agregamspartner' );
  add_shortcode( 'telefono', 'agregatelefono' );
  add_shortcode( 'nombreshop', 'agreganombreshop' );
  add_action('woocommerce_admin_order_data_after_order_details','paypal1');//sale en edit de order
  add_shortcode( 'urltienda', 'urlTienda' );
  add_shortcode( 'vertrag', 'agregavertrag' );
  add_shortcode( 'lizenzgeber', 'agregalizenzgeber' );
  function agregaustidnr_init(){
    function agregaustidnr() {
 	  $options = get_option( '_invoices_options' );
	  return $options['ustidnr'];
   }
   function agregacorreo() {
		$args = shortcode_atts( array(
				'eslink' => 's',
			), $attr );
		$options = get_option( '_invoices_options' );
		if ($args['eslink']=="s"){
			return "<a href='mailto:".$options['correo_factura']."'>".$options['correo_factura']."</a>";
		}else{
			return $options['correo_factura'];
		}
   }
   function agregadireccion() {
	  $options = get_option( '_invoices_options' );
	  return $options['direccion_factura'];
   }
   function agregadireccion2() {
  	  $options = get_option( '_invoices_options' );
	  return $options['direccion2_factura'];
   }
   function agregamspartner() {
  	  $options = get_option( '_invoices_options' );
	  return $options['mspartner'];
   }
   function agregatelefono() {
  	  $options = get_option( '_invoices_options' );
	  return $options['telefono'];
   }
   function agreganombreshop() {
  	  $options = get_option( 'wpo_wcpdf_settings_general' );
	  return $options['shop_name']['default'];
   }
	function paypal1($post){//sale en edit de order
		$tt=get_post_meta( $post->id,'_payment_method' );
		if ($tt[0]=='paypal'||$tt[0]=='ppec_paypal'){
			$options1 = get_post_meta( $post->id,'paypal_receiver' );
			echo "<p class='form-field form-field-wide wc-customer-user' style='color:blue;padding-top:190px;border:solid 1px gray;border-radius:3px;'>Paypal receiver: ".$options1[0]."</p>";
		}	
	}
	function urlTienda($attr){
		$args = shortcode_atts( array(
				'eslink' => 's',
				'prtcl'  => 's',
			), $attr );
		$home = get_option( 'siteurl' );
		if ($args['prtcl']<>"s"){
			$home=str_replace("https://", "", $home);
			$home=str_replace("http://", "", $home);
			$home=str_replace("https//", "", $home);
			$home=str_replace("http//", "", $home);
		}
		
		if ($args['eslink']=="s"){
			return "<a href='$home'>$home</a>";
		}else{
			return $home;
		}
	}
   function agregavertrag() {
  	  $options = get_option( '_invoices_options' );
	  return $options['vertrag'];
   }
   function agregalizenzgeber() {
  	  $options = get_option( '_invoices_options' );
	  return $options['lizenzgeber'];
   }
  }
  add_action('init', 'agregaustidnr_init');

/////// FIN: MENU PARAMETROS FACTURA
